﻿using System;
using System.Data;

public class PatientImage
{
    public int Id { get; set; }
    public int PatientId { get; set; }
    public DateTime DateImaged { get; set; }
    public string SystemIdentifiedFragment { get; set; }
    public string ImageUrl { get; set; }
    public int? LargestFragmentSize { get; set; }
    public int? SmallestFragmentSize { get; set; }
    public int? ImageBodyPartId { get; set; }
    public int? ImageFragmentCountId { get; set; }
    public int? ImageTypeId { get; set; }

    public PatientImage(DataRow dr)
    {
        Id = dr.Field<int>("PATIENT_IMAGE_ID");
        PatientId = dr.Field<int>("PATIENT_ID");
        DateImaged = dr.Field<DateTime>("DATE_IMAGED");
        SystemIdentifiedFragment = dr.Field<string>("SYSTEM_IDENTIFIED_FRAGMENT");
        ImageUrl = dr.Field<string>("IMAGE_URL");
        LargestFragmentSize = dr.Field<int?>("LARGEST_FRAGMENT_SIZE");
        SmallestFragmentSize = dr.Field<int?>("SMALLEST_FRAGMENT_SIZE");
        ImageBodyPartId = dr.Field<int?>("STD_IMAGE_BODY_PART_ID");
        ImageFragmentCountId = dr.Field<int?>("STD_IMAGE_FRAGMENT_COUNT_ID");
        ImageTypeId = dr.Field<int?>("STD_IMAGE_TYPE_ID");
    }
}